%Binning the data by trial, for example: summarize pokes from the first 10
%Go trials, then from the next 10 and so on....
%As input insert how many bins you want - 2, 3...So if there are 30 trials
%and 2 Bins, the trials will be summarized from 1 to 15, and then 16 to 30.

function [SummaryTableBins] = BinningSingleFile(resultFile, Bins)


data = load(resultFile);
NPoints = data.NPoints - 1;
NTrials = length(data.TrialTimeIndices);
nPeriods = 4; %Assume there are 4 periods per presentation      
SensoryPortEventData = data.NosePoke;
FileID = resultFile;
[Paths, FileID] = strtok(FileID,'_');
NTrialTypes = max(cell2mat(data.ProtocolDef.TrialsIdxAssembly));

%Execute functions
[TrialByTrialOutput, SummaryTable] = VariableTrialsScriptOneExpResults(resultFile);

SummaryTableBins = SummarizeData (TrialByTrialOutput);





    function SummaryTableBins = SummarizeData (TrialByTrialOutput)
        % Create a grand table were the data foe all the trials are
        % summarized and/or averaged
        %SummaryTable2Size = Bins*NTrialTypes;
        %SummaryTableBins = cell(1,24);
        SummaryTableBins = {};
        RowIDx = 1;
        %      1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24
 %Summary table																							
 %File ID	Animal ID	Session ID	Control ID	Group	
 %Trial Type	Premature pokes	Precue response rate	Response port Pokes in Cue	Latency to poke in Cue	
 %Total Trials Finished	% of Correct GO trials/False alarms trials with premature	% of Correct GO trials/False alarms trials excluding premature	Reward Port Total licks in Reward	Response port pokes in Precue	
 %Response Port pokes in Cue	Response Port pokes in Reward	Response Port Total pokes in ITI	Response port total pokes	Reward port Total pokes Precue	
 % Reward port Total pokes Cue 	Reward port Total pokes Reward	Reward port Total pokes ITI	Reward port total pokes
        
        for jj = 1:NTrialTypes

            LengthTrial = length(TrialByTrialOutput{1,jj}(:,1));
            BinSize = ceil(LengthTrial/Bins);
            
            for Periods = 1:Bins

            StartPosition = BinSize*(Periods-1)+1;
            
            if (BinSize*Periods <= LengthTrial)
            EndPosition = BinSize*Periods;
            else
            EndPosition = LengthTrial;
            end
            
            SummaryTableTemp(RowIDx,1)= TrialByTrialOutput{1,jj}(1,1);
            
            %  kk- column in Trial by trial output table , jj - trial type
                       
            %AnimalID
            SummaryTableTemp{RowIDx,2} = FileID(10:13);
            %SessionID
            SummaryTableTemp{RowIDx,3} = FileID(6:8);
            %Endp Trial
            SummaryTableTemp{RowIDx,4} = EndPosition;
            %TrialType
            SummaryTableTemp{RowIDx,6} = cell2mat(TrialByTrialOutput{1,jj}(1,2));
            %Premature pokes
            SummaryTableTemp{RowIDx,7} = sum(cell2mat(TrialByTrialOutput{1,jj}(StartPosition:EndPosition,4)));
            %Average precue response rate 8/5
            SummaryTableTemp{RowIDx,8} = mean(cell2mat(TrialByTrialOutput{1,jj}(StartPosition:EndPosition,5)));
            %Response port Pokes in Cue 9/7
            SummaryTableTemp{RowIDx,9} = sum(cell2mat(TrialByTrialOutput{1,jj}(StartPosition:EndPosition,7)));
            %Average Latency to poke in Cue - average 10/12
            SummaryTableTemp{RowIDx,10} = nanmean(cell2mat(TrialByTrialOutput{1,jj}(StartPosition:EndPosition,12)));
            % Total trials finished 11/2
            TotalTrialsFinished = size((TrialByTrialOutput{1,jj}(StartPosition:EndPosition,2)));
            SummaryTableTemp{RowIDx,11} = TotalTrialsFinished(1,1);
            % Reward Port Total licks in Reward 14/10
            SummaryTableTemp{RowIDx,14} = nansum(cell2mat(TrialByTrialOutput{1,jj}(StartPosition:EndPosition,10)));
            % 15-18 Response port pokes in Precue, Cue, Reward, ITI /6-9
            for kk = 15:18
              SummaryTableTemp{RowIDx,kk} = sum(cell2mat(TrialByTrialOutput{1,jj}(StartPosition:EndPosition,kk-9)));
            end
            % 19 Response port total pokes /11
            SummaryTableTemp{RowIDx,19} = sum(cell2mat(TrialByTrialOutput{1,jj}(StartPosition:EndPosition,11)));
            % 20-23 Reward port pokes in Precue, Cue, Reward, ITI /14-17
            for kk = 20:23
              SummaryTableTemp{RowIDx,kk} = sum(cell2mat(TrialByTrialOutput{1,jj}(StartPosition:EndPosition,kk-6)));
            end
            % 24 Reward port total pokes/18
            SummaryTableTemp{RowIDx,24} = sum(cell2mat(TrialByTrialOutput{1,jj}(StartPosition:EndPosition,18)));
            % of Correct GO trials/False alarms trials with premature 12
            SummaryTableTemp{RowIDx,12} = (SummaryTableTemp{RowIDx,16}/SummaryTableTemp{RowIDx,11})*100;
            % of Correct GO trials/False alarms trials excluding premature
            % 13
            SummaryTableTemp{RowIDx,13} = (SummaryTableTemp{RowIDx,16}/(SummaryTableTemp{RowIDx,11}-SummaryTableTemp{RowIDx,7}))*100;
            %NAns present in 10, 12, 13, so licks, Latency to poke in Cue and Air puff/Premature response
            %Add Latency in Poked Trials
            SummaryTableTemp{RowIDx,25} = nanmean(cell2mat(TrialByTrialOutput{1,jj}(StartPosition:EndPosition)));
            
            SummaryTableBins = [SummaryTableBins; SummaryTableTemp];
            end
        end
    end

end